/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	GetActivePartWorkplaneSketch.cpp

#include <stdafx.h>

#include "cUtility.h"

#include "cApplication.h"

HRESULT GetActivePartWorkplaneSketch(IPartDocument **activePart,
									 IGraphicDocument **activeGraphicDoc,
									 IWorkplane **activeWorkplane,
									 ISketch **activeSketch)
{

//  Queries the  PartDocument, Workplane , and Sketch Interfaces and
//	returns the active Part, active Workplane, active Sketch

	START_METHOD("GetActivePartWorkplaneSketch")

	HRESULT status = NOERROR;
	IDispatch *pDisp = NULL;

	IPartDocument *part = NULL;
	IWorkplane *workplane = NULL;

	ISketch * sketch = NULL;
	IApplication *pdApplication = NULL;

	// Get the application
	status = GetProDESKTOPApplication(&pdApplication) ;
	CHECK_RETURN_STATUS(status)

	status = pdApplication->GetActiveDoc(activeGraphicDoc);
	CHECK_RETURN_STATUS(status)

	*activePart = CAST(IPartDocument, *activeGraphicDoc);

	// Get active workplane
	status = (*activeGraphicDoc)->GetActiveWorkplane(activeWorkplane);
	CHECK_RETURN_STATUS(status)

	// Get active sketch
	status = (*activeGraphicDoc)->GetActiveSketch(activeSketch);
	CHECK_RETURN_STATUS(status)

	END_METHOD("GetActivePartWorkplaneSketch")
}

HRESULT GetActiveDrawingDoc(IDrawingDocument **activeDraw,
									 IGraphicDocument **activeGraphicDoc)
{

	START_METHOD("GetActiveDrawingDoc")

	HRESULT status = NOERROR;

	IApplication *pdApplication = NULL;

	// Get the application
	status = GetProDESKTOPApplication(&pdApplication) ;
	CHECK_RETURN_STATUS(status)

	status = pdApplication->GetActiveDoc(activeGraphicDoc);
	CHECK_RETURN_STATUS(status)

	*activeDraw = CAST(IDrawingDocument, *activeGraphicDoc);

	END_METHOD("GetActiveDrawingDoc")
}